<h3 class="mb-3 fw-bold">Inventaris & Aset</h3>
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <div class="mb-3">
            <!-- Tombol jadi Biru biar seragam -->
            <button class="btn btn-primary fw-bold" data-bs-toggle="modal" data-bs-target="#mBarang">
                <i class="bi bi-plus-lg me-1"></i> Tambah Aset
            </button>
        </div>

        <!-- Tambahkan class 'table-data' disini -->
        <table id="tabelBarang" class="table table-bordered table-hover w-100 table-data">
            <thead class="table-light">
                <tr>
                    <th>Nama Barang</th>
                    <th>Lokasi</th>
                    <th>Kondisi</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $q = mysqli_query($koneksi, "SELECT * FROM inventaris ORDER BY lokasi ASC"); 
                while($d = mysqli_fetch_array($q)){ 
                    // Badge Kondisi
                    $badge = 'bg-success';
                    if($d['kondisi']=='Rusak Ringan') $badge='bg-warning text-dark';
                    if($d['kondisi']=='Rusak Berat') $badge='bg-danger';
                ?>
                <tr>
                    <td><b><?php echo $d['nama_barang']; ?></b></td>
                    <td><?php echo $d['lokasi']; ?></td>
                    <td><span class="badge <?php echo $badge; ?>"><?php echo $d['kondisi']; ?></span></td>
                    <td class="text-center">
                        <a href="?page=edit_barang&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-warning py-0">Edit</a>
                        <a href="proses/act_sarpras.php?aksi=hapus_barang&id=<?php echo $d['id']; ?>" class="btn btn-sm btn-danger py-0" onclick="return confirm('Hapus aset ini?')">X</a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Tambah Barang -->
<div class="modal fade" id="mBarang">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="proses/act_sarpras.php">
                <div class="modal-header"><h5>Tambah Aset</h5></div>
                <div class="modal-body">
                    <input name="nama_barang" class="form-control mb-2" placeholder="Nama Barang" required>
                    <select name="lokasi" class="form-select mb-2">
                        <option>Lab Komputer</option>
                        <option>Kelas</option>
                        <option>Kantor</option>
                        <option>Gudang</option>
                    </select>
                    <select name="kondisi" class="form-select">
                        <option value="Baik">Baik</option>
                        <option value="Rusak Ringan">Rusak Ringan</option>
                        <option value="Rusak Berat">Rusak Berat</option>
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" name="simpan_barang" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>